```bash
#!/bin/bash

ROOT_DIR="$1"  # Root directory passed as an argument

find "$ROOT_DIR" -maxdepth 1 -type d -print0 | while IFS= read -r -d $'\0' dir; do
  if [ -f "$dir/docker-compose.yaml" ]; then
    echo "Processing: $dir"
    (
      cd "$dir" || exit 1  # Changed || to exit 1 for clearer error handling
      docker compose pull && docker compose up -d
    )
  fi
done

echo "Completed processing all subdirectories."
```